/*
 * Decompiled with CFR 0.152.
 */
package com.technicalitiesmc.lib.container.item.adapter;

import com.technicalitiesmc.lib.container.item.ItemContainer;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;
import org.jetbrains.annotations.NotNull;

public class ItemHandlerToItemContainerAdapter
implements ItemContainer {
    private final IItemHandler itemHandler;

    public ItemHandlerToItemContainerAdapter(IItemHandler itemHandler) {
        this.itemHandler = itemHandler;
    }

    @Override
    public int size() {
        return this.itemHandler.getSlots();
    }

    @Override
    @NotNull
    public ItemStack get(int slot) {
        return this.itemHandler.getStackInSlot(slot);
    }

    @Override
    public void set(int slot, @NotNull ItemStack stack) {
        IItemHandler iItemHandler = this.itemHandler;
        if (iItemHandler instanceof IItemHandlerModifiable) {
            IItemHandlerModifiable modifiable = (IItemHandlerModifiable)iItemHandler;
            modifiable.setStackInSlot(slot, stack);
        } else {
            this.itemHandler.extractItem(slot, Integer.MAX_VALUE, false);
            this.itemHandler.insertItem(slot, stack, false);
        }
    }

    @Override
    public boolean isValid(int slot, @NotNull ItemStack stack) {
        return this.itemHandler.isItemValid(slot, stack);
    }

    @Override
    public int getMaxStackSize(int slot) {
        return this.itemHandler.getSlotLimit(slot);
    }

    @Override
    @NotNull
    public IItemHandlerModifiable asItemHandler() {
        IItemHandler iItemHandler = this.itemHandler;
        if (iItemHandler instanceof IItemHandlerModifiable) {
            IItemHandlerModifiable modifiable = (IItemHandlerModifiable)iItemHandler;
            return modifiable;
        }
        return ItemContainer.super.asItemHandler();
    }
}

